/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.content.lang.sl.SimpleSLTokenizer;
import jade.core.CaseInsensitiveString;
import jade.util.leap.Comparable;
import jade.util.leap.EnumIterator;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class AID
implements Comparable,
Serializable {
    private static String platformID;
    private String name;
    private int hashCode;
    private static final int EXPECTED_ADDRESSES_SIZE = 1;
    private static final int EXPECTED_RESOLVERS_SIZE = 1;
    private Vector addresses = new Vector(1, 1);
    private Vector resolvers = new Vector(1, 1);
    private Properties userDefSlots = new Properties();
    public static final boolean ISGUID = true;
    public static final boolean ISLOCALNAME = false;
    public static final String AGENT_CLASSNAME = "JADE-agent-classname";
    private transient Long persistentID;

    public AID() {
        this("", true);
    }

    public AID(String guid) {
        this(guid, true);
    }

    public AID(String name, boolean isGUID) {
        if (isGUID) {
            this.setName(name);
        } else {
            this.setLocalName(name);
        }
    }

    static final String getPlatformID() {
        return platformID;
    }

    static final void setPlatformID(String id) {
        platformID = id;
    }

    public void setName(String n) {
        this.name = n.trim();
        this.hashCode = this.name.toLowerCase().hashCode();
    }

    public void setLocalName(String n) {
        String hap = AID.getPlatformID();
        if (hap == null) {
            throw new RuntimeException("Unknown Platform Name");
        }
        this.name = n.trim();
        if (this.name.length() <= hap.length() || !this.name.regionMatches(true, this.name.length() - hap.length(), hap, 0, hap.length())) {
            this.name = this.name.concat("@" + hap);
        }
        this.hashCode = this.name.toLowerCase().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void addAddresses(String url) {
        if (!this.addresses.contains(url)) {
            this.addresses.addElement(url);
        }
    }

    public boolean removeAddresses(String url) {
        return this.addresses.removeElement(url);
    }

    public void clearAllAddresses() {
        this.addresses.removeAllElements();
    }

    public Iterator getAllAddresses() {
        return new EnumIterator(this.addresses.elements());
    }

    public void addResolvers(AID aid) {
        if (!this.resolvers.contains(aid)) {
            this.resolvers.addElement(aid);
        }
    }

    public boolean removeResolvers(AID aid) {
        return this.resolvers.removeElement(aid);
    }

    public void clearAllResolvers() {
        this.resolvers.removeAllElements();
    }

    public Iterator getAllResolvers() {
        return new EnumIterator(this.resolvers.elements());
    }

    public void addUserDefinedSlot(String key, String value) {
        this.userDefSlots.setProperty(key, value);
    }

    public boolean removeUserDefinedSlot(String key) {
        return this.userDefSlots.remove(key) != null;
    }

    public String[] getAddressesArray() {
        Object[] result = new String[this.addresses.size()];
        this.addresses.copyInto(result);
        return result;
    }

    private void setAddressesArray(String[] arr) {
        this.addresses.removeAllElements();
        int i = 0;
        while (i < arr.length) {
            this.addAddresses(arr[i]);
            ++i;
        }
    }

    public AID[] getResolversArray() {
        Object[] result = new AID[this.resolvers.size()];
        this.resolvers.copyInto(result);
        return result;
    }

    private void setResolversArray(AID[] arr) {
        this.resolvers.removeAllElements();
        int i = 0;
        while (i < arr.length) {
            this.addResolvers(arr[i]);
            ++i;
        }
    }

    public Properties getAllUserDefinedSlot() {
        return this.userDefSlots;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("( agent-identifier ");
        s.append(":name ");
        s.append(SimpleSLTokenizer.isAWord(this.name) ? this.name : SimpleSLTokenizer.quoteString(this.name));
        if (this.addresses.size() > 0) {
            s.append(" :addresses (sequence ");
        }
        int i = 0;
        while (i < this.addresses.size()) {
            try {
                s.append((String)this.addresses.elementAt(i));
                s.append(" ");
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (this.addresses.size() > 0) {
            s.append(")");
        }
        if (this.resolvers.size() > 0) {
            s.append(" :resolvers (sequence ");
        }
        int i2 = 0;
        while (i2 < this.resolvers.size()) {
            try {
                s.append(this.resolvers.elementAt(i2).toString());
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            s.append(" ");
            ++i2;
        }
        if (this.resolvers.size() > 0) {
            s.append(")");
        }
        Enumeration e = this.userDefSlots.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.userDefSlots.getProperty(key);
            s.append(" :X-");
            s.append(key);
            s.append(" ");
            s.append(SimpleSLTokenizer.isAWord(value) ? value : SimpleSLTokenizer.quoteString(value));
        }
        s.append(")");
        return s.toString();
    }

    public synchronized Object clone() {
        AID result = new AID(this.name, true);
        result.persistentID = null;
        result.addresses = new Vector(this.addresses.size());
        int i = 0;
        while (i < this.addresses.size()) {
            result.addresses.addElement(this.addresses.elementAt(i));
            ++i;
        }
        result.resolvers = new Vector(this.resolvers.size());
        int i2 = 0;
        while (i2 < this.resolvers.size()) {
            result.resolvers.addElement(this.resolvers.elementAt(i2));
            ++i2;
        }
        result.userDefSlots = this.userDefSlots;
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof AID) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, ((AID)o).name);
        }
        if (o instanceof String) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, (String)o);
        }
        return false;
    }

    public int compareTo(Object o) {
        AID id = (AID)o;
        return this.name.toLowerCase().toUpperCase().compareTo(id.name.toLowerCase().toUpperCase());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getLocalName() {
        int atPos = this.name.lastIndexOf(64);
        if (atPos == -1) {
            return this.name;
        }
        return this.name.substring(0, atPos);
    }

    public String getHap() {
        int atPos = this.name.lastIndexOf(64);
        if (atPos == -1) {
            return null;
        }
        return this.name.substring(atPos + 1);
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }
}

